package com.cnooc.expertmanageminiapp.manage.controller;

import com.cnooc.expertmanageminiapp.common.response.Result;
import com.cnooc.expertmanageminiapp.manage.service.TrainingService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 培训/考试
 * @author: FuHongZhang
 * @date 2025-10-24 10:52
 */
@Slf4j
@RestController
@RequestMapping("/training")
public class TrainingController {

    @Autowired
    private TrainingService trainingService;


    /**
     * 培训课程列表查询
     * @return Result<String> 统一返回操作码及信息
     */
    @GetMapping("/getCourseListInfo")
    public Result<String> getCourseListInfo() {
        return null;
    }

    /**
     * 根据id查询课程详情
     * @return Result<String> 统一返回操作码及信息
     */
    @GetMapping("/getCourseById")
    public Result<String> getCourseById() {
        return null;
    }


    /**
     * 课程详情-课节列表信息
     * @return Result<String> 统一返回操作码及信息
     */
    @GetMapping("/getCourseLessonById")
    public Result<String> getCourseLessonById() {
        return null;
    }

    /**
     * 课节学习接口
     * @return Result<String> 统一返回操作码及信息
     */
    @GetMapping("/getCourseLessonStudy")
    public Result<String> getCourseLessonStudy() {
        return null;
    }

    /**
     * 查询附件列表
     * @return Result<String> 统一返回操作码及信息
     */
    @GetMapping("/getAttachList")
    public Result<String> getAttachList() {
        return null;
    }

    /**
     * 更新学习进度
     * @return Result<String> 统一返回操作码及信息
     */
    @GetMapping("/updateLearnProgress")
    public Result<String> updateLearnProgress() {
        return null;
    }


    /**
     * 考试列表查询
     * @return Result<String> 统一返回操作码及信息
     */
    @GetMapping("/getExamListInfo")
    public Result<String> getExamListInfo() {
        return null;
    }


    /**
     * 查询考试试卷
     * @return Result<String> 统一返回操作码及信息
     */
    @GetMapping("/getExamPaper")
    public Result<String> getExamPaper() {
        return null;
    }

    /**
     * 保存专家考试记录
     * @return Result<String> 统一返回操作码及信息
     */
    @GetMapping("/saveExpertExamRecord")
    public Result<String> saveExpertExamRecord() {
        return null;
    }


    /**
     * 查询考试答题集合列表
     * @return Result<String> 统一返回操作码及信息
     */
    @GetMapping("/getExamAnswerList")
    public Result<String> getExamAnswerList() {
        return null;
    }


    /**
     * 获取小题列表
     * @return Result<String> 统一返回操作码及信息
     */
    @GetMapping("/getExamQuestionList")
    public Result<String> getExamQuestionList() {
        return null;
    }

    /**
     * 保存考试试卷
     * @return Result<String> 统一返回操作码及信息
     */
    @GetMapping("/submitExamPaper")
    public Result<String> submitExamPaper() {
        return null;
    }


}
