package com.cnooc.expertmanageminiapp.manage.entity.pojo;

import com.cnooc.expertmanageminiapp.common.utils.CommonUtil;
import com.cnooc.expertmanageminiapp.system.Enum.MinZu;
import com.cnooc.expertmanageminiapp.system.Enum.ZhuanJiaZhuangTai;
import lombok.*;
import org.springframework.data.annotation.Id;

import java.beans.Transient;
import java.io.Serializable;
import java.util.List;

/**
 * 专家信息实体类
 * @author lijia
 * @date - 2016年01月19日
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ZhuanJiaInfo implements Serializable {

    private static final long serialVersionUID = -1L;

    // 基础标识字段
//    @Column(name = "ZhuanJia_Guid")
    private String zhuanJiaGuid;

//    @Column(name = "ZhuanJia_ShiXiang_Guid")
    private String zhuanJiaShiXiangGuid;

//    @Column(name = "ZhuanJia_Name")
    private String zhuanJiaName;

//    @Column(name = "ZhuanJia_Code")
    private String zhuanJiaCode;

//    @Column(name = "ShenFenZheng")
    private String shenFenZheng;

    // 状态字段
//    @Column(name = "ZHUANJIA_ZHUANGTAI")
    private Short zhuanJiaZhuangTai;

//    @Column(name = "SHIFOU_YIFAZHUANJIA")
    private Boolean shiFouYiFaZhuanJia;

//    @Column(name = "ShenPi_ZhuangTai")
    private Short shenPiZhuangTai;

    // 基本信息
//    @Column(name = "Birthday")
    private String birthday;

//    @Column(name = "Sex")
    private Boolean sex;

//    @Column(name = "Age")
    private Short age;

//    @Column(name = "Mobile")
    private String mobile;

//    @Column(name = "Email")
    private String email;

//    @Column(name = "ZhengZhi_MianMao")
    private String zhengZhiMianMao;

//    @Column(name = "WaiYu_ChengDu")
    private String waiYuChengDu;

//    @Column(name = "XueLi")
    private String xueLi;

//    @Column(name = "XueWei")
    private String xueWei;

//    @Column(name = "XueLi_ZhuanYe")
    private String xueLiZhuanYe;

//    @Column(name = "XueWei_ZhuanYe")
    private String xueWeiZhuanYe;

//    @Column(name = "BiYe_YuanXiao")
    private String biYeYuanXiao;

//    @Column(name = "Graduation_Date")
    private String graduationDate;

//    @Column(name = "JiaTing_DiZhi")
    private String jiaTingDiZhi;

//    @Column(name = "JiaTing_Post")
    private String jiaTingPost;

//    @Column(name = "JiaTing_Phone")
    private String jiaTingPhone;

    // 工作信息
//    @Column(name = "GongZuo_ZhuangTai")
    private Short gongZuoZhuangTai;

//    @Column(name = "GongZuo_DanWei")
    private String gongZuoDanWei;

//    @Column(name = "GongZuo_DanWei_BH")
    private String gongZuoDanWeiBH;

//    @Column(name = "GongZuo_DanWei_DiZhi")
    private String gongZuoDanWeiDiZhi;

//    @Column(name = "GongZuo_Phone")
    private String gongZuoPhone;

//    @Column(name = "GongZuo_ZhiWu")
    private String gongZuoZhiWu;

//    @Column(name = "GongZuo_Post")
    private String gongZuoPost;

//    @Column(name = "GongZuo_ZhuanYe_Name")
    private String gongZuoZhuanYeName;

//    @Column(name = "GongZuo_ZhuanYe_Years")
    private String gongZuoZhuanYeYears;

    // 评标相关信息
//    @Column(name = "PingBiao_TuiJian_LX")
    private Short pingBiaoTuiJianLX;

//    @Column(name = "PingBiao_ChangZhu_DiQu")
    private String pingBiaoChangZhuDiQu;

//    @Column(name = "PingBiao_QiTa_DiQu")
    private String pingBiaoQiTaDiQu;

//    @Column(name = "PingBiao_YingJi_DiQu")
    private String pingBiaoYingJiDiQu;

//    @Column(name = "PingBiao_Is_YingJi")
    private Boolean pingBiaoIsYingJi;

    // 专业能力
//    @Column(name = "ZhuanYe_JingLi")
    private String zhuanYeJingLi;

//    @Column(name = "CanYu_XiangMu")
    private String canYuXiangMu;

//    @Column(name = "DanRen_QiTa_ZhuanJia")
    private String danRenQiTaZhuanJia;

//    @Column(name = "ZhuanYe_TeChang")
    private String zhuanYeTeChang;

//    @Column(name = "BuNeng_RuXuan_QingKong")
    private String buNengRuXuanQingKong;

    // 附件信息
//    @Column(name = "FuJian_Guids")
    private String fuJianGuids;

//    @Column(name = "Photo_Guid")
    private String photoGuid;

    // 时间信息
//    @Column(name = "TiJiao_Time")
    private Long tiJiaoTime;

//    @Column(name = "ShenPi_Ren")
    private String shenPiRen;

//    @Column(name = "ShenPi_YiJian")
    private String shenPiYiJian;

//    @Column(name = "ShenPi_ShiJian")
    private Long shenPiShiJian;

//    @Column(name = "ShenQing_LeiXing")
    private Short shenQingLeiXing;

//    @Column(name = "BianGeng_XuHao")
    private Short bianGengXuHao;

//    @Column(name = "Is_Deleted")
    private Boolean isDeleted;

//    @Column(name = "Creator_Name")
    private String creatorName;

//    @Column(name = "create_time")
    private Long createTime;

//    @Column(name = "Modifier_Name")
    private String modifierName;

//    @Column(name = "Modify_Time")
    private Long modifyTime;

//    @Column(name = "TuiKu_YuanYin")
    private String tuiKuYuanYin;

    // 权限信息
    private List<String> auths;

    // 登录信息
//    @Column(name = "ZhangHao")
    private String zhangHao;

//    @Column(name = "Password")
    private String password;

    // 其他信息
//    @Column(name = "MinZu")
    private String minZu;

//    @Column(name = "JianKang_ZhuangKuang")
    private String jianKangZhuangKuang;

//    @Column(name = "Sfz_FileGuid")
    private String sfzFileGuid;

//    @Column(name = "FANMIANFUJIAN_GUIDS")
    private String fanMianFuJianGuids;

//    @Column(name = "Fax")
    private String fax;

//    @Column(name = "Byz_FileGuid")
    private String byzFileGuid;

//    @Column(name = "SuoShu_BuMeng")
    private String suoShuBuMeng;

//    @Column(name = "Jgdm_FileGuid")
    private String jgdmFileGuid;

//    @Column(name = "IS_IMPORT")
    private Boolean isImport;

//    @Column(name = "SuoShu_ZhaoBiaoDaiLi")
    private String suoShuZhaoBiaoDaiLi;

//    @Column(name = "isXiuGai")
    private Boolean isXiuGai;

//    @Column(name = "yinHangKa")
    private String yinHangKa;

//    @Column(name = "yinHang")
    private String yinHang;

//    @Column(name = "yinHang1")
    private String yinHang1;

//    @Column(name = "Mobile_GuoJi_QuHao")
    private String mobileGuoJiQuHao;

//    @Column(name = "LEIJI_FENZHI")
    private Long leiJiFenZhi;

//    @Column(name = "LEIJI_ZHANTING_TIME")
    private Long leiJiZhanTingTime;

//    @Column(name = "ZIDONGZANTING_END_TIME")
    private Long ziDongZanTingEndTime;

//    @Column(name = "ZIDONGZANTING_START_TIME")
    private Long ziDongZanTingStartTime;

//    @Column(name = "yingJi_zhuangTai")
    private Integer yingJiZhuangTai;

//    @Column(name = "yinHangKa_file_guid")
    private String yinHangKaFileGuid;

//    @Column(name = "TUISONG_SHIBAI_CISHU_SJTJ")
    private Integer tuiSongShiBaiCiShuSJTJ;

//    @Column(name = "IS_TUISONG_SJTJ")
    private Boolean isTuiSongSJTJ;

//    @Column(name = "ZHUANJIA_SUOZAIDI_NAMES")
    private String zhuanJiaSuoZaiDiNames;

//    @Column(name = "ZHUANJIA_SUOZAIDI_GUIDS")
    private String zhuanJiaSuoZaiDiGuids;

//    @Column(name = "ZHUANJIA_TYPE")
    private Short zhuanJiaType;

//    @Column(name = "PROFESSION_LEVEL")
    private String professionLevel;

//    @Column(name = "is_senior")
    private Boolean isSenior;

//    @Column(name = "suoshu_hangye")
    private String suoShuHangYe;

//    @Column(name = "city")
    private String city;

//    @Column(name = "danwei_guid")
    private String danweiGuid;

//    @Column(name = "zhuanjia_fenlei")
    private Short zhuanJiaFenLei;

//    @Column(name = "zhuanjia_pinrenqi")
    private Short zhuanjiaQinRenQi;

//    @Column(name = "pinqi_start_time")
    private Long pinqiStartTime;

//    @Column(name = "pinqi_end_time")
    private Long pinqiEndTime;

//    @Column(name = "qita_lianxi_fangshi")
    private String qiTaLianXiFangShi;

//    @Column(name = "zhuanjia_source_type")
    private Short zhuanJiaSourceType;

//    @Column(name = "suoshudanwei_name")
    private String suoShuDanWeiName;

//    @Column(name = "is_zhiyezige")
    private Boolean isZhiYeZiGe;

//    @Column(name = "gongzuo_time")
    private Long gongZuoTime;

//    @Column(name = "is_qualified")
    private Boolean isQualified;

//    @Column(name = "is_read_ruku_promise")
    private Boolean isReadRuKuPromise;

//    @Column(name = "read_ruku_promise_time")
    private Long readRuKuPromiseTime;

//    @Column(name = "ingroup")
    private Boolean inGroup;

//    @Column(name = "ad_account")
    private String adAccount;

//    @Column(name = "zhuanjia_zonghe_bianhao")
    private String zhuanJiaZongHeBianHao;

//    @Column(name = "has_lianjie_chuli_yijian")
    private Boolean hasLianJieChuLiYiJian;

//    @Column(name = "jituan_erji_danwei_code")
    private String jiTuanErJiDanWeiCode;

//    @Column(name = "jituan_erji_danwei_name")
    private String jiTuanErJiDanWeiName;

//    @Column(name = "suozai_qita_zhuanjiaku")
    private String suoZaiQitaZhuanJiaKu;

//    @Column(name = "huojiang_qingkuang")
    private String huoJiangQingKuang;

//    @Column(name = "gongzuo_beizhu")
    private String gongZuoBeiZhu;

//    @Column(name = "zhuanjia_fenji")
    private Short zhuanJiaFenJi;

    // 临时字段=
    private String zhuanYeGuid;

    @Transient
    private String getZhuanYeGuid() {
        return zhuanYeGuid;
    }

    private String zhuanJiaSuoZaiDiQuName;

    @Transient
    private String getZhuanJiaSuoZaiDiQuName() {
        return zhuanJiaSuoZaiDiQuName;
    }

    private SysDict pingBiaoSheng;

    @Transient
    public SysDict getPingBiaoSheng() {
        return pingBiaoSheng;
    }

    private SysDict pingBiaoShi;

    @Transient
    public SysDict getPingBiaoShi() {
        return pingBiaoShi;
    }

    // 业务逻辑方法
    @Transient
    public String getTiJiaoTimeText() {
        return CommonUtil.longTimeToString(this.tiJiaoTime);
    }

    @Transient
    public String getCreateTimeText() {
        return CommonUtil.longTimeToString(this.createTime);
    }

    @Transient
    public String getModifyTimeText() {
        return CommonUtil.longTimeToString(this.modifyTime);
    }

    @Transient
    public String getBaseGuid() {
        return this.zhuanJiaGuid;
    }

    @Transient
    public String getBaseName() {
        return this.zhuanJiaName;
    }

    @Transient
    public String getBaseCode() {
        return this.getZhuanJiaCode();
    }

    @Transient
    public String getBaseSFZH() {
        return this.shenFenZheng;
    }

    @Transient
    public String getBaseZhuangTai() {
        return this.zhuanJiaZhuangTai != null ? this.zhuanJiaZhuangTai.toString() : "";
    }

    @Transient
    public String getBaseShenPiZhuangTai() {
        return this.shenPiZhuangTai != null ? this.shenPiZhuangTai.toString() : "";
    }

    @Transient
    public List<String> getBaseAuths() {
        return this.auths;
    }

    @Transient
    public String getBaseMobile() {
        return this.mobile;
    }

    @Transient
    public String getMobileGJQHText() {
        return "+" + this.mobileGuoJiQuHao + "&nbsp;" + this.mobile;
    }

    @Transient
    public String getZhuanJiaZhuangTaiText() {
        String name = "";
        if (zhuanJiaZhuangTai != null) {
            ZhuanJiaZhuangTai zhuanJiaZhuangTai = ZhuanJiaZhuangTai.getZhuanJiaZhuangTai(this.zhuanJiaZhuangTai);
            if (zhuanJiaZhuangTai != null) {
                return zhuanJiaZhuangTai.getDescription();
            }
        }
        return name;
    }

    @Transient
    public String getMinZuText() {
        if (this.minZu != null) {
            try {
                Short value = Short.valueOf(this.minZu);
                return MinZu.getEnum(value).getDescription();
            } catch (Exception e) {
                return this.minZu;
            }
        }
        return "";
    }

    public ZhuanJiaInfo(String zhuanJiaGuid) {
        this.zhuanJiaGuid = zhuanJiaGuid;
    }
}
