package com.cnooc.expertmanageminiapp.system.controller;

import com.cnooc.expertmanageminiapp.common.response.Result;
import com.cnooc.expertmanageminiapp.common.utils.ValidUtils;
import com.cnooc.expertmanageminiapp.system.entity.vo.LoginVO;
import com.cnooc.expertmanageminiapp.system.entity.vo.VerifyCodeVO;
import com.cnooc.expertmanageminiapp.system.service.LoginService;
import io.netty.util.internal.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @Author: FuHongZhang
 * @CreateTime: 2025-09-18  15:03
 */

@Slf4j
@RestController
@RequestMapping("/sys")
public class LoginController {

    @Autowired
    private LoginService loginService;


    /**
     * 手机号验证码/身份证号密码 登录功能
     * @param loginVO 登录表单
     * @return Result<String> 统一返回操作码及信息
     */
    @PostMapping("/login")
    public Result<String> login(@Validated @RequestBody LoginVO loginVO) {
        // 校验loginType 不为空
        return loginService.login(loginVO);
    }


    /**
     * 获取验证码
     * @param phoneNumber 手机号必传
     * @return Result<Integer> 统一返回操作结果及验证码
     */
    @GetMapping("/sendCode/{phoneNumber}")
    public Result<String> sendCode(@PathVariable String phoneNumber) {
        log.info("获取验证码的手机号: {}", phoneNumber);
        return loginService.sendPhoneCode(phoneNumber);
    }


    @PostMapping("/verifyCode")
    public Result<String> verifyCode(@RequestBody VerifyCodeVO codeVO) {
        return loginService.verifyCode(codeVO);
    }





    /**
     * 账号修改
     * @param loginVO
     * @return
     */
    public Result<String> changePass(@RequestBody LoginVO loginVO) {
        return loginService.changePass(loginVO);
    }

}
