package com.cnooc.expert.system.operatelog.dto;

import lombok.Data;

@Data
public class LogBody {
    /**
     * 业务模块标识
     */
    private String appId;

    /**
     * 业务模块名称
     */
    private String appName;

    /**
     * 用户账号
     */
    private String account;


    /**
     * 用户名称
     */
    private String userName;

    /**
     * 操作所在IP地址(用户操作实际ip非系统代理ip)
     */
    private String ip;


    /**
     * 用户操作时间戳（毫秒）服务器时间
     */
    private long operationTs;

    /**
     * 用户所属单位id(取到部门一级)
     */
    private Long domainId;

    /**
     * 用户所属单位名称(取到部门一级)
     */
    private String domainName;

    /**
     * 请求方法
     */
    private String requestMethod;

    /**
     * 请求路径path
     */
    private String requestPath;

    /**
     * 请求参数
     */
    private String requestArgs;

    /**
     * 返回参数，文件下载无需该字段
     */
    private String responseContent;
    /**
     * 身份类型(内部用户、内部供应商、外部供应商、内部专家、外部专家)
     */
    private String role;
    /**
     * 操作事件类型(1:登录,2:登出,3:添加,4:编辑,5:删除,6:查询,7:下载,8:打印,9:导入,10:导出,11:启动,12:停用,13:其它)
     */
    private Integer action;

    /**
     * 操作记录id，使用UUID.randomUUID().toString()生成
     */
    private String operateRecordId;

    /**
     * imos的用户id
     */
    private String userId;
}
