/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.key.server.util;

import com.wangyin.key.server.jni.AKSNativeCryptoService;
import com.wangyin.key.server.model.Key;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KernalUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(KernalUtil.class);

    public static int putKey(List<Key> keys) {
        Key key;
        int code = 0;
        Iterator<Key> i$ = keys.iterator();
        while (i$.hasNext() && (code = AKSNativeCryptoService.setKey((key = i$.next()).getToken(), key.getAlias(), key.getValue())) == 0) {
            LOGGER.info("{} put key ok", (Object)key.getAlias());
        }
        return code;
    }

    public static int putKey(List<Key> keys, Set<String> aliasNameSet) {
        int code = 0;
        for (Key key : keys) {
            try {
                aliasNameSet.add(key.getAlias().split("-")[0]);
            }
            catch (RuntimeException e) {
                LOGGER.warn("WARNING: Unexpected aliasName type: " + key.getAlias(), (Throwable)e);
                aliasNameSet.add(key.getAlias());
            }
            code = AKSNativeCryptoService.setKey(key.getToken(), key.getAlias(), key.getValue());
            if (code != 0) break;
            LOGGER.info("{} put key ok", (Object)key.getAlias());
        }
        return code;
    }

    public static void deleteKey(List<Key> keys) {
        for (Key k : keys) {
            try {
                AKSNativeCryptoService.removeKey(k.getAlias());
            }
            catch (Exception e) {
                LOGGER.warn("Delete Key Exception: {}", (Object)e.getMessage());
            }
        }
    }
}

