package com.cnooc.expert.common.utils;

import com.cnooc.expertmanageminiapp.system.entity.pojo.ZhuanJiaUser;
import org.springframework.stereotype.Component;

/**
 * 用户id获取工具类
 * @author: FuHongZhang
 * @date 2025-10-24 11:14:07
 */
@Component("userUtils")
public class UserUtils {

    public static ZhuanJiaUser getCurrentUser() {
        ZhuanJiaUser zhuanJiaUser = USER_INFO.get();
        if (zhuanJiaUser != null) {
            return zhuanJiaUser;
        }
        return null;
    }

    private static final ThreadLocal<ZhuanJiaUser> USER_INFO = new ThreadLocal<>();
    
    public static void setUserId(ZhuanJiaUser zhuanJiaUser) {
        USER_INFO.set(zhuanJiaUser);
    }
    
    public static ZhuanJiaUser getUserId() {
        return USER_INFO.get();
    }
    
    public static void clear() {
        USER_INFO.remove();
    }
}