package com.cnooc.expert.config;

import com.google.gson.Gson;
import okhttp3.OkHttpClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

import java.util.concurrent.TimeUnit;

@Configuration
@Profile("prod")
public class RetrofitProdConfiguration {

    /**
     * 专家服务
     * @param gson
     * @return
     */
    @Bean("retrofitExpert")
    @Primary
    public Retrofit RetrofitExpert(Gson gson) {
        return createRetrofit("https://prod.randomuser.me/", gson);
    }

    /**
     * 工作流服务
     * @param gson
     * @return
     */
    @Bean("retrofitWorkflow")
    public Retrofit RetrofitWorkflow(Gson gson) {
        return createRetrofit("https://prod.randomuser.com/", gson);
    }

    /**
     * 平台服务
     * @param gson
     * @return
     */
    @Bean("retrofitPortal")
    public Retrofit RetrofitPortal(Gson gson) {
        return createRetrofit("https://prod.randomuser.cn/", gson);
    }

    /**
     * 主体服务
     * @param gson
     * @return
     */
    @Bean("retrofitSubject")
    public Retrofit RetrofitSubject(Gson gson) {
        return createRetrofit("https://prod.randomuser.cn.com/", gson);
    }

    private Retrofit createRetrofit(String baseUrl, Gson gson) {
        OkHttpClient okHttpClient = new OkHttpClient.Builder()
                .connectTimeout(30, TimeUnit.SECONDS)
                .readTimeout(30, TimeUnit.SECONDS)
                .build();

        return new Retrofit.Builder()
                .baseUrl(baseUrl)
                .client(okHttpClient)
                .addConverterFactory(GsonConverterFactory.create(gson))
                .build();
    }

}
