package com.cnooc.expert.service;

import com.cnooc.expert.common.response.BasePageResp;
import com.cnooc.expert.controller.workflow.model.request.ApprovePathSettingPageReq;
import com.cnooc.expert.controller.workflow.model.response.ApprovePathSettingPageResp;
import com.cnooc.expert.external.workflow.service.WorkflowServiceClient;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

@AllArgsConstructor
@Service
public class WorkflowService {

    private final WorkflowServiceClient workflowServiceClient;

    public BasePageResp<ApprovePathSettingPageResp> pageApprovePathSetting(ApprovePathSettingPageReq req) {

        List<ApprovePathSettingPageResp.ApprovePathAccount> accountList = Lists.newArrayList(
                ApprovePathSettingPageResp.ApprovePathAccount.builder()
                        .account("ex_liujh27")
                        .name("刘俊")
                        .subjectName("中国海洋石油集团有限公司")
                        .email("ex_liujh27@cnooc.com.cn")
                        .build()
        );

        List<ApprovePathSettingPageResp.ApprovePath> templatePaths = Lists.newArrayList(
                ApprovePathSettingPageResp.ApprovePath.builder()
                        .nodeId("node246ec7f3c7571dd631a93f34fa8aeb4b")
                        .nodeName("一级")
                        .approvePersonName("刘俊")
                        .subjectName("中国海洋石油集团有限公司")
                        .email("ex_liujh27@cnooc.com.cn")
                        .accountList(accountList)
                        .build()
        );

        List<ApprovePathSettingPageResp> data = Lists.newArrayList(
                ApprovePathSettingPageResp.builder()
                        .defId("e2dbccf455ec448b8a8284dc2c6c3b04")
                        .defName("中移深化-专家审批")
                        .opinion(null)
                        .pathId(null)
                        .useIfream(true)
                        .engineType(1)
                        .ifreamUrl("https://flow.t-bid.cnooc.com.cn/deta/scene-talk/approvalFlowChart.html?templateId=e2dbccf455ec448b8a8284dc2c6c3b04&approveId=")
                        .fileId(null)
                        .suggestMsg("1111")
                        .receiveSettingCode(null)
                        .receiveSettingName(null)
                        .upSubjectName(null)
                        .upSubjectId(null)
                        .needUpApproval(null)
                        .signingComments(null)
                        .noNeedUpApprovalCode(null)
                        .noNeedUpApprovalInfo(null)
                        .templatePaths(templatePaths)
                        .build()
        );

        return BasePageResp.<ApprovePathSettingPageResp>builder()
                .current(1)
                .pages(1)
                .total(1)
                .data(data)
                .build();
    }
}
