package com.cnooc.expert.external.file.sevice;

import com.cnooc.expert.external.common.AbstractRetrofitManager;
import com.cnooc.expert.external.common.model.response.ApiBaseResult;
import com.cnooc.expert.external.file.api.FileServiceApi;
import com.cnooc.expert.external.file.model.request.GeneratorDownloadInfoApiReq;
import com.cnooc.expert.external.file.model.response.DownLoadInfoDTO;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import retrofit2.Call;
import retrofit2.Retrofit;

import java.util.List;

@Service
public class FileServiceClient extends AbstractRetrofitManager {

    private final FileServiceApi fileServiceApi;

    public FileServiceClient(@Qualifier("retrofitFile") Retrofit retrofit) {
        this.fileServiceApi = retrofit.create(FileServiceApi.class);
    }

    public ApiBaseResult<List<DownLoadInfoDTO>> generatorDownloadInfo(String pathId) {
        GeneratorDownloadInfoApiReq apiReq = GeneratorDownloadInfoApiReq.builder()
                .pathId(pathId)
                .build();
        Call<ApiBaseResult<List<DownLoadInfoDTO>>> call = fileServiceApi.generatorDownloadInfoApi(apiReq);
        return this.getResponseBody(call, "generatorDownloadInfo");
    }

}
