/*
 * Decompiled with CFR 0.152.
 */
package com.jd.jr.aks.security.crypto.paks;

import com.jd.jr.aks.api.AksClient;
import com.jd.jr.aks.api.AksHttpClientFactory;
import com.jd.jr.aks.api.model.AksResponse;
import com.jd.jr.aks.security.crypto.Decryption;
import com.jd.jr.aks.security.crypto.aks.AbstractAksCipher;
import com.jd.jr.aks.security.crypto.paks.PAksConfig;
import com.jd.jr.aks.security.exception.DecryptException;
import com.jd.jr.aks.security.exception.FailFastException;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPAksCipher
implements Decryption {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)AbstractPAksCipher.class.getName());
    private AksClient client;

    void init() {
        PAksConfig config = this.config();
        try {
            LOGGER.info("[AKS CONFIG SECURITY:1.2.3] AKS privatization\u5f00\u59cb\u8fdb\u884c\u521d\u59cb\u5316.");
            AksHttpClientFactory factory = new AksHttpClientFactory(config.getAccessKey(), config.getDomain());
            AksClient client = factory.createClient();
            if (!client.isLogin()) {
                throw new RuntimeException("[AKS CONFIG SECURITY:1.2.3] AKS privatization\u767b\u9646\u5931\u8d25");
            }
            this.client = client;
        }
        catch (Exception e) {
            LOGGER.error("[AKS CONFIG SECURITY:1.2.3] AKS privatization\u521d\u59cb\u5316\u5931\u8d25.", (Throwable)e);
            throw new FailFastException(e);
        }
        LOGGER.info("[AKS CONFIG SECURITY:1.2.3] AKS privatization\u521d\u59cb\u5316\u5b8c\u6210.");
    }

    abstract PAksConfig config();

    @Override
    public String decrypt(String ciphertext) throws DecryptException {
        try {
            AksResponse response = this.client.decrypt(ciphertext);
            if (!response.isSuccess()) {
                throw new RuntimeException(response.getResponseMessage());
            }
            byte[] bytes = response.getPlainByte();
            return new String(bytes, "UTF-8");
        }
        catch (Exception e) {
            throw new DecryptException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PAksConfig tryLoadConfig() {
        InputStream stream = null;
        try {
            PAksConfig pAksConfig;
            PropertyDescriptor[] descriptors;
            stream = AbstractAksCipher.class.getClassLoader().getResourceAsStream("important.properties");
            Properties props = new Properties();
            props.load(stream);
            PAksConfig config = new PAksConfig();
            BeanInfo beanInfo = Introspector.getBeanInfo(PAksConfig.class);
            for (PropertyDescriptor property : descriptors = beanInfo.getPropertyDescriptors()) {
                String name = property.getName();
                Method method = property.getWriteMethod();
                if ("class".equals(name) || name == null || method == null || !props.containsKey(name = "aks.config.security." + name)) continue;
                method.invoke((Object)config, props.getProperty(name));
            }
            if (config.emptyConfig()) {
                pAksConfig = null;
                return pAksConfig;
            }
            pAksConfig = config;
            return pAksConfig;
        }
        catch (Exception e) {
            PAksConfig pAksConfig = null;
            return pAksConfig;
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                stream = null;
            }
        }
    }
}

