/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.key.server;

import com.wangyin.key.server.DeviceCryptoService;
import com.wangyin.key.server.IBaseCryptoService;
import com.wangyin.key.server.exception.AksExceptionEnum;
import com.wangyin.key.server.exception.AuthException;
import com.wangyin.key.server.exception.KeyException;
import com.wangyin.key.server.jni.AKSNativeCryptoService;
import com.wangyin.key.server.model.AksMessage;
import com.wangyin.key.server.model.DigestAlgEnum;
import com.wangyin.key.server.model.ErrorMessage;
import com.wangyin.key.server.thread.ChannelExecutor;
import com.wangyin.key.server.util.AKSConstant;
import com.wangyin.key.server.util.ByteUtil;
import com.wangyin.key.server.util.CacheUtil;
import com.wangyin.key.server.util.Preconditions;
import com.wangyin.key.server.util.StatusUtil;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class CryptoServiceBase {
    String token_keyAlias = "";
    IBaseCryptoService cryptoDisService;
    String appID;
    String appName;
    String aliasNames;
    String tsaUrl = "http://aks-timestamp-proxy.jdpay.local/j/tsa";
    String hsmZkAddress = "aks-zk1.d.chinabank.com.cn:22181,aks-zk2.d.chinabank.com.cn:22181,aks-zk3.d.chinabank.com.cn:22181,aks-zk4.d.chinabank.com.cn:22181,aks-zk5.d.chinabank.com.cn:22181";
    int hsmTimeout = 10000;
    String initType = "hsmsys";
    String chipsZkAddress = "aks-zk1.d.chinabank.com.cn:22181,aks-zk2.d.chinabank.com.cn:22181,aks-zk3.d.chinabank.com.cn:22181,aks-zk4.d.chinabank.com.cn:22181,aks-zk5.d.chinabank.com.cn:22181";
    int chipsTimeout = 10000;
    String chipsSysId = "first-sys";
    int chipsFamily = 1;
    int heartbeatInterval = AKSConstant.retryInterval;
    boolean ignoreInitError = false;
    boolean initSuccess = true;
    ConcurrentHashMap<String, Long> indexHandle = new ConcurrentHashMap();

    void readProps() throws IOException {
        if (this.appID == null || this.appID.length() == 0) {
            Properties prop = new Properties();
            InputStream in = DeviceCryptoService.class.getResourceAsStream("/key.properties");
            if (in == null) {
                throw new KeyException(AksExceptionEnum.AKS_99_99979.getCode(), AksExceptionEnum.AKS_99_99979.getDesc());
            }
            prop.load(in);
            this.appID = prop.getProperty("AppID");
            if (this.appID == null || this.appID.length() == 0) {
                throw new KeyException(AksExceptionEnum.AKS_99_99980.getCode(), AksExceptionEnum.AKS_99_99980.getDesc());
            }
            this.appName = prop.getProperty("AppName") == null ? this.appID : prop.getProperty("AppName");
            this.aliasNames = prop.getProperty("aliasNames");
            this.tsaUrl = prop.getProperty("TSAUrl") == null ? "http://aks-timestamp-proxy.jdpay.local/j/tsa" : prop.getProperty("TSAUrl");
            this.hsmZkAddress = prop.getProperty("hsm.zk.address") == null ? "aks-zk1.d.chinabank.com.cn:22181,aks-zk2.d.chinabank.com.cn:22181,aks-zk3.d.chinabank.com.cn:22181,aks-zk4.d.chinabank.com.cn:22181,aks-zk5.d.chinabank.com.cn:22181" : prop.getProperty("hsm.zk.address");
            try {
                this.hsmTimeout = Integer.parseInt(prop.getProperty("hsm.timeout"));
            }
            catch (NumberFormatException e) {
                this.hsmTimeout = 10000;
            }
            this.initType = prop.getProperty("init.type") == null ? "hsmsys" : prop.getProperty("init.type");
            this.chipsZkAddress = prop.getProperty("chips.zk.address") == null ? "aks-zk1.d.chinabank.com.cn:22181,aks-zk2.d.chinabank.com.cn:22181,aks-zk3.d.chinabank.com.cn:22181,aks-zk4.d.chinabank.com.cn:22181,aks-zk5.d.chinabank.com.cn:22181" : prop.getProperty("chips.zk.address");
            try {
                this.chipsTimeout = Integer.parseInt(prop.getProperty("chips.timeout"));
            }
            catch (NumberFormatException e) {
                this.chipsTimeout = 10000;
            }
            this.chipsSysId = prop.getProperty("chips.sys.id") == null ? "first-sys" : prop.getProperty("chips.sys.id");
            try {
                this.chipsFamily = Integer.parseInt(prop.getProperty("chips.family"));
            }
            catch (NumberFormatException e) {
                this.chipsFamily = 0;
            }
        }
    }

    String getToken() throws KeyException {
        Preconditions.validate(this.appID);
        return CacheUtil.getInstance().getToken(this.appID);
    }

    String getApiVersion() throws KeyException {
        Preconditions.validate(this.appID);
        return CacheUtil.getInstance().getApiVersion(this.appID);
    }

    String getTokenAndApiVersion() throws KeyException {
        String serverVersion = CacheUtil.getInstance().getServerVersion(this.appID);
        String _value = serverVersion == null || serverVersion.isEmpty() ? this.getToken() : this.getToken() + "|" + this.getApiVersion();
        return _value;
    }

    boolean isOnLine() {
        if (!AKSNativeCryptoService.isLinuxSystem) {
            return true;
        }
        return StatusUtil.getInstance().isOnLine(this.appID);
    }

    void setOffLineStatus() {
        StatusUtil.getInstance().setOffLineStatus(this.appID);
    }

    public void setAppID(String appID) {
        this.appID = appID;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setAliasNames(String aliasNames) {
        this.aliasNames = aliasNames;
    }

    public void setTsaUrl(String tsaUrl) {
        this.tsaUrl = tsaUrl;
    }

    public void setHsmZkAddress(String hsmZkAddress) {
        this.hsmZkAddress = hsmZkAddress;
    }

    public void setHsmTimeout(int hsmTimeout) {
        this.hsmTimeout = hsmTimeout;
    }

    public String getChipsZkAddress() {
        return this.chipsZkAddress;
    }

    public void setChipsZkAddress(String chipsZkAddress) {
        this.chipsZkAddress = chipsZkAddress;
    }

    public int getChipsTimeout() {
        return this.chipsTimeout;
    }

    public void setChipsTimeout(int chipsTimeout) {
        this.chipsTimeout = chipsTimeout;
    }

    public String getChipsSysId() {
        return this.chipsSysId;
    }

    public void setChipsSysId(String chipsSysId) {
        this.chipsSysId = chipsSysId;
    }

    public int getChipsFamily() {
        return this.chipsFamily;
    }

    public void setChipsFamily(int chipsFamily) {
        this.chipsFamily = chipsFamily;
    }

    public void setAppId(String appId) {
        this.appID = appId;
    }

    public void setHeartbeatInterval(int heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval == Integer.MAX_VALUE ? heartbeatInterval : (heartbeatInterval > 3600 ? 3600 : heartbeatInterval);
    }

    public ErrorMessage getErrorMessage(String key) {
        return AksMessage.getMessage(key);
    }

    public IBaseCryptoService getCryptoDisService() {
        return this.cryptoDisService;
    }

    public void setCryptoDisService(IBaseCryptoService cryptoDisService) {
        this.cryptoDisService = cryptoDisService;
    }

    public boolean isIgnoreInitError() {
        return this.ignoreInitError;
    }

    public void setIgnoreInitError(boolean ignoreInitError) {
        this.ignoreInitError = ignoreInitError;
    }

    String createTokenKeyAlias(String token) {
        String ret = "tok_02_001-";
        String tmp_value = "";
        byte[] salt = new byte[32];
        SecureRandom random = new SecureRandom();
        random.nextBytes(salt);
        tmp_value = String.format("%s-%d-%s", token, System.nanoTime(), ByteUtil.bytesToHexString(salt));
        tmp_value = this.md5(tmp_value.getBytes());
        ret = ret + tmp_value.substring(tmp_value.length() - 12);
        return ret;
    }

    String md5(byte[] srcData) throws KeyException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(DigestAlgEnum.ALG_MD5.getCode());
        }
        catch (NoSuchAlgorithmException e) {
            return "773a3d14fddab4813e4ed234f9525802";
        }
        return ByteUtil.bytesToHexString(md.digest(srcData));
    }

    public void logout() throws AuthException {
        ChannelExecutor.getExecutor().stopStatusMonitor(this.appID);
    }
}

