package com.cnooc.expert;

import com.cnooc.expert.common.response.ApiResult;
import lombok.AllArgsConstructor;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@AllArgsConstructor
@RestController
public class Ping {

    private final StringRedisTemplate redisTemplate;

    @GetMapping("/ping")
    public ApiResult<String> ping() {
        redisTemplate.opsForValue().set("ping", "Pong");
        return ApiResult.successWithResult("Pong");
    }

}
