package com.cnooc.expert.external.workflow.service;

import com.cnooc.expert.external.common.AbstractRetrofitManager;
import com.cnooc.expert.external.common.model.request.ProcDefPageApiReq;
import com.cnooc.expert.external.common.model.response.ApiBaseResult;
import com.cnooc.expert.external.common.model.response.ApiPagination;
import com.cnooc.expert.external.workflow.api.WorkflowServiceApi;
import com.cnooc.expert.external.workflow.model.request.InstRevokeApiReq;
import com.cnooc.expert.external.workflow.model.request.InstStartApiReq;
import com.cnooc.expert.external.workflow.model.response.InstStartApiResp;
import com.cnooc.expert.external.workflow.model.response.ProcDefPageApiResp;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import retrofit2.Call;
import retrofit2.Retrofit;

import java.util.Map;

@Service
public class WorkflowServiceClient extends AbstractRetrofitManager {

    private final WorkflowServiceApi workflowServiceApi;

    public WorkflowServiceClient(@Qualifier("retrofitWorkflow") Retrofit retrofit) {
        this.workflowServiceApi = retrofit.create(WorkflowServiceApi.class);
    }

    // 审批发起
    public ApiBaseResult<InstStartApiResp> startInst(InstStartApiReq apiReq) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<InstStartApiResp>> call = workflowServiceApi.startInstApi(headers, apiReq);
        return this.getResponseBody(call, "startInst");
    }

    // 审批撤回
    public ApiBaseResult<Void> revokeInst(InstRevokeApiReq apiReq) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<Void>> call = workflowServiceApi.revokeInstApi(headers, apiReq);
        return this.getResponseBody(call, "revokeInst");
    }

    // 审批路径分页
    public ApiBaseResult<ApiPagination<ProcDefPageApiResp>> pageProcDef(ProcDefPageApiReq apiReq) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<ApiPagination<ProcDefPageApiResp>>> call = workflowServiceApi.pageProcDefApi(headers, apiReq);
        return this.getResponseBody(call, "pageProcDef");
    }


}
