package com.cnooc.expert.service;

import com.cnooc.expert.external.common.model.response.ApiBaseResult;
import com.cnooc.expert.external.pingbiao.model.request.SignOptimizeReq;
import com.cnooc.expert.external.pingbiao.model.response.FaceDynResp;
import com.cnooc.expert.external.pingbiao.model.response.IdentifyFaceDynResp;
import com.cnooc.expert.external.pingbiao.model.response.SignValidityPeriodResp;
import com.cnooc.expert.external.pingbiao.model.response.WhitelistStatusResp;
import com.cnooc.expert.external.pingbiao.service.PingBiaoServiceClient;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

@AllArgsConstructor
@Service
public class PingBiaoService {

    private final PingBiaoServiceClient pingBiaoServiceClient;

    public SignValidityPeriodResp getSignValidityPeriod(SignOptimizeReq request) {
        ApiBaseResult<SignValidityPeriodResp> apiResp = pingBiaoServiceClient.getSignValidityPeriod(request);
        return apiResp.getData();
    }

    public WhitelistStatusResp queryInsideSignUser(SignOptimizeReq request) {

        ApiBaseResult<WhitelistStatusResp> apiResp = pingBiaoServiceClient.queryInsideSignUser(request);
        return apiResp.getData();
    }

    public WhitelistStatusResp queryOutsidePerson(SignOptimizeReq request) {

        ApiBaseResult<WhitelistStatusResp> apiResp = pingBiaoServiceClient.queryOutsidePerson(request);
        return apiResp.getData();
    }

    public WhitelistStatusResp createOutsidePerson(SignOptimizeReq request) {

        ApiBaseResult<WhitelistStatusResp> apiResp = pingBiaoServiceClient.createOutsidePerson(request);
        return apiResp.getData();
    }
    public FaceDynResp getFaceDyn(SignOptimizeReq request) {

        ApiBaseResult<FaceDynResp> apiResp = pingBiaoServiceClient.getFaceDyn(request);
        return apiResp.getData();
    }
    public IdentifyFaceDynResp identifyFaceDyn(SignOptimizeReq request) {

        ApiBaseResult<IdentifyFaceDynResp> apiResp = pingBiaoServiceClient.identifyFaceDyn(request);
        return apiResp.getData();
    }
    public WhitelistStatusResp sendSceneCode(SignOptimizeReq request) {

        ApiBaseResult<WhitelistStatusResp> apiResp = pingBiaoServiceClient.sendSceneCode(request);
        return apiResp.getData();
    }
    public WhitelistStatusResp validSceneCode(SignOptimizeReq request) {

        ApiBaseResult<WhitelistStatusResp> apiResp = pingBiaoServiceClient.validSceneCode(request);
        return apiResp.getData();
    }

}
