package com.cnooc.expert.service;

import com.cnooc.expert.common.response.BasePageResp;
import com.cnooc.expert.controller.workflow.model.request.ApprovePathSettingPageReq;
import com.cnooc.expert.controller.workflow.model.response.ApprovePathSettingPageResp;
import com.cnooc.expert.external.common.model.request.ProcDefPageApiReq;
import com.cnooc.expert.external.common.model.response.ApiBaseResult;
import com.cnooc.expert.external.common.model.response.ApiPagination;
import com.cnooc.expert.external.workflow.model.request.InstRevokeApiReq;
import com.cnooc.expert.external.workflow.model.request.InstStartApiReq;
import com.cnooc.expert.external.workflow.model.response.InstStartApiResp;
import com.cnooc.expert.external.workflow.model.response.ProcDefPageApiResp;
import com.cnooc.expert.external.workflow.service.WorkflowServiceClient;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

@AllArgsConstructor
@Service
public class WorkflowService {

    private final WorkflowServiceClient workflowServiceClient;

    public InstStartApiResp startInst(InstStartApiReq req) {
        ApiBaseResult<InstStartApiResp> apiResp = workflowServiceClient.startInst(req);
        return apiResp.getData();
    }

    public Boolean revokeInst(InstRevokeApiReq req) {
        workflowServiceClient.revokeInst(req);
        return Boolean.TRUE;
    }


    public BasePageResp<ProcDefPageApiResp> pageApprovePathSetting(ApprovePathSettingPageReq req) {
        ProcDefPageApiReq apiReq = ProcDefPageApiReq.builder()
                .pageNum(req.getPageNo())
                .pageSize(req.getPageSize())
                .businessId(req.getBusinessId())
                .businessTypeCode(req.getBusinessTypeCode())
                .subjectId(req.getSubjectId())
                .build();
        ApiBaseResult<ApiPagination<ProcDefPageApiResp>> apiResp = workflowServiceClient.pageProcDef(apiReq);

        ApiPagination<ProcDefPageApiResp> pageResp = apiResp.getData();

        return BasePageResp.<ProcDefPageApiResp>builder()
                .current(pageResp.getPageNo())
                .pages(pageResp.getPageNum())
                .total(pageResp.getTotalCount())
                .data(pageResp.getList())
                .build();
    }
}
